#!/bin/bash

version=1.0.5
name=libnuevomatchup
libdir=/usr/lib
hdrdir=/usr/include
mydir=$(dirname $(readlink -f $0))

echo "${name} v.$version installation script"

if [[ "$EUID" -ne 0 ]]; then
    echo "Please run me as root."
    exit 1
fi

function search_flag() {
    [[ $(cat /proc/cpuinfo | grep $1 | wc -l) -ne 0 ]]
}

function check_version() {
    if [[ ! -e $libdir/${name}.so ]]; then
        return 0
    fi
    current=$(readlink -f $libdir/${name}.so | \
              sed -E 's/(.*\.so\.)([\.0-9]+$)/\2/g' | \
              sed 's/\.//g')
    new=$(echo "$version" | sed 's/\.//g')
    if [[ $new > $current ]]; then
        return 0
    else
        return 1
    fi
}

if ! search_flag avx; then
    echo "Your CPU does not support AVX extension."
    exit 1
fi

if ! search_flag fma; then
    echo "Your CPU does not support FMA extension."
    exit 1
fi

if ! search_flag popcnt; then
    echo "Your CPU does not support POPCNT extension."
    exit 1
fi

if search_flag avx2; then
    sfx=avx2
else
    echo "Your CPU does not support AVX2 extension." \
         "performance will be slower than usual."
    sfx=avx
fi

lib=${name}.${sfx}.so
hdr=${name}.h

if check_version; then
    echo "An equal/newer version of the library was found in the system."
    read -p \
        "Do you wish to [U]ninstall, [R]einstall, or [C]ancel (default)?: " a
    if [[ $a == [Uu] ]]; then
        echo "Uninstalling..."
        rm -f ${libdir}/${name}*
        rm -f ${hdrdir}/${hdr}
        ldconfig 2>/dev/null
        exit 0
    elif [[ $a != [Rr] ]]; then
        exit 0
    fi
fi

echo "Copying $lib to ${libdir}"
cp $mydir/$lib ${libdir}/${lib}.${version}
rm -f ${libdir}/${name}.so
ln -s ${libdir}/${lib}.${version} ${libdir}/${name}.so

echo "Copying $hdr to ${hdrdir}"
cp $mydir/$hdr ${hdrdir}/${hdr}.${version}
rm -f ${hdrdir}/${hdr}
ln -s ${hdrdir}/${hdr}.${version} ${hdrdir}/${hdr}

ldconfig 2>/dev/null

